/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.gamecontext;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import technology.rocketjump.undermount.entities.EntityUpdater;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.gamecontext.GameContextRegister;
import technology.rocketjump.undermount.gamecontext.Updatable;
import technology.rocketjump.undermount.jobs.JobAccessibilityUpdater;
import technology.rocketjump.undermount.jobs.JobRequestHandler;
import technology.rocketjump.undermount.rendering.lighting.AttachedLightSourceProcessor;
import technology.rocketjump.undermount.rooms.constructions.ConstructionUpdater;
import technology.rocketjump.undermount.settlement.ItemTracker;

@Singleton
public class GameUpdateRegister {
    private final Map<String, Updatable> registered = new HashMap<String, Updatable>();
    private final GameContextRegister gameContextRegister;

    @Inject
    public GameUpdateRegister(GameContextRegister gameContextRegister) {
        this.gameContextRegister = gameContextRegister;
    }

    public void init(Injector injector) {
        this.registerClasses(injector, JobRequestHandler.class, JobAccessibilityUpdater.class, EntityUpdater.class, ItemTracker.class, ConstructionUpdater.class, AttachedLightSourceProcessor.class);
    }

    private void registerClasses(Injector injector, Class<? extends Updatable> ... updatableClasses) {
        for (Class<? extends Updatable> updatableClass : updatableClasses) {
            this.register(injector.getInstance(updatableClass));
        }
    }

    public void update(float deltaTime, boolean isPaused) {
        for (Updatable updatable : this.registered.values()) {
            if (!updatable.runWhilePaused() && isPaused) continue;
            updatable.update(deltaTime);
        }
    }

    public void register(Updatable updatableInstance) {
        String className = updatableInstance.getClass().getName();
        if (this.registered.containsKey(className)) {
            throw new RuntimeException("Duplicate class registered in " + this.getClass().getName() + ": " + className);
        }
        this.registered.put(className, updatableInstance);
        if (updatableInstance instanceof GameContextAware) {
            this.gameContextRegister.register((GameContextAware)((Object)updatableInstance));
        }
    }
}

